#include "stdafx.h"
#include "emule.h"
#include "PPg_X_General.h"
#include "opcodes.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Log.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CPPg_X_General, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPg_X_General, CPropertyPage)
ON_WM_HSCROLL()

 //dlarge lowIdRetry
	ON_EN_CHANGE(IDC_LOWIDRETRY, OnSettingsChange)
//dlarge end

END_MESSAGE_MAP()

CPPg_X_General::CPPg_X_General()
	: CPropertyPage(CPPg_X_General::IDD)
{
}

CPPg_X_General::~CPPg_X_General()
{
}

void CPPg_X_General::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPg_X_General::OnInitDialog()
{
	CString strBuffer;
   //dlarge lowIdRetry
	strBuffer.Format(_T("%d"), thePrefs.GetLowIdRetries());
	GetDlgItem(IDC_LOWIDRETRY)->SetWindowText(strBuffer);
//dlarge end

	CPropertyPage::OnInitDialog();

	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPg_X_General::OnApply()
{
//dlarge lowIdRetry
	CString buffers;
	if(GetDlgItem(IDC_LOWIDRETRY)->GetWindowTextLength())
	{
		GetDlgItem(IDC_LOWIDRETRY)->GetWindowText(buffers);
		thePrefs.SetLowIdRetries((uint8)(_tstoi(buffers)));
	}
//dlarge end

//dlarge NiceHash
	thePrefs.SetNiceHashWeight((uint8)((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->GetPos()); 
//dlarge end

	LoadSettings();
	return TRUE;
}

void CPPg_X_General::LoadSettings()
{

//dlarge NiceHash
	((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->SetRange(0, 100, true); 
	((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->SetPos(thePrefs.GetNiceHashWeight()); 
	((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->SetTicFreq(10);                     
//dlarge end

}

void CPPg_X_General::Localize()
{
CString temp;
	if (m_hWnd)
	{

//dlarge lowIdRetry
		GetDlgItem(IDC_LOWIDRETRYLABEL)->SetWindowText(GetResString(IDS_LOWIDRETRYLABEL));
//dlarge end

//dlarge NiceHash
		CString temp;
		temp.Format(GetResString(IDS_PRF_GEN_NICEHASH_STATIC), MS2SEC((float)((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->GetPos()*10)); 
		GetDlgItem(IDC_PRF_GEN_NICEHASH_STATIC)->SetWindowText(temp);
		GetDlgItem(IDC_PRF_GEN_NICEHASH_RIGHT_LBL)->SetWindowText(GetResString(IDS_PRF_GEN_NICEHASH_RIGHT_LBL));
		GetDlgItem(IDC_PRF_GEN_NICEHASH_LEFT_LBL)->SetWindowText(GetResString(IDS_PRF_GEN_NICEHASH_LEFT_LBL));
		GetDlgItem(IDC_PRF_GEN_NICEHASH_GRP)->SetWindowText(GetResString(IDS_PRF_GEN_NICEHASH_GRP)); 
//dlarge end

	}
}

void CPPg_X_General::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);
//dlarge NiceHash
	if( pScrollBar == (CScrollBar*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))
		ShowNiceHashValue();
//dlarge end

	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

//dlarge NiceHash
void CPPg_X_General::ShowNiceHashValue()
{
	CString temp;
	temp.Format(GetResString(IDS_PRF_GEN_NICEHASH_STATIC), MS2SEC((float)((CSliderCtrl*)GetDlgItem(IDC_PRF_GEN_NICEHASH_SLIDER))->GetPos()*10)); 
	GetDlgItem(IDC_PRF_GEN_NICEHASH_STATIC)->SetWindowText(temp);
}
//dlarge end